--> pralable
-- USE BD_Air_France;

IF OBJECT_ID('dbo.T_affretements ','U') IS NOT NULL
   DROP TABLE dbo.T_affretements ;
GO
IF OBJECT_ID('dbo.T_compagnie','U') IS NOT NULL
   DROP TABLE dbo.T_compagnie;
GO

CREATE TABLE T_compagnie
(comp CHAR(4), nom CHAR(15), pays CHAR(4));
INSERT INTO T_compagnie VALUES ('SING', 'Singapore AL', 'SG');
INSERT INTO T_compagnie	VALUES ('AF','Air France', 'F');
INSERT INTO T_compagnie	VALUES ('ALIB','Air Lib', 'F');
GO

CREATE TABLE T_affretements
(immat CHAR(5), typeav CHAR(8),compa CHAR(4), dateaff DATE);
GO

INSERT INTO T_affretements VALUES ('A1', 'A320', 'SING', '2005-05-13');
INSERT INTO T_affretements VALUES ('A2', 'A340', 'AF', '2008-06-22');
INSERT INTO T_affretements VALUES ('A3', 'Mercure', 'AF', '2005-02-05');
INSERT INTO T_affretements VALUES ('A4', 'A330', 'ALIB', '2005-01-16');
INSERT INTO T_affretements VALUES ('A3', 'Mercure', 'ALIB', '2002-03-05');
INSERT INTO T_affretements VALUES ('A3', 'Mercure', 'SING', '2007-03-01');

/* Division inexacte */

SELECT DISTINCT t1.immat, t1.typeav 
FROM   T_affretements t1
WHERE  NOT EXISTS
      (SELECT comp FROM T_compagnie WHERE pays = 'F'
       EXCEPT
       SELECT compa FROM T_affretements WHERE immat = t1.immat);

DELETE FROM T_affretements WHERE immat='A3' AND compa='SING';

/* Division exacte */

SELECT DISTINCT t1.immat, t1.typeav FROM T_affretements t1
  WHERE NOT EXISTS
   (SELECT comp FROM T_compagnie WHERE pays = 'F'
    EXCEPT
    SELECT compa FROM T_affretements WHERE immat = t1.immat)
  AND NOT EXISTS
   (SELECT compa FROM T_affretements WHERE immat = t1.immat 
    EXCEPT
    SELECT comp FROM T_compagnie WHERE pays = 'F');

--

IF OBJECT_ID('dbo.T_affretements ','U') IS NOT NULL
   DROP TABLE dbo.T_affretements ;
GO
IF OBJECT_ID('dbo.T_compagnie','U') IS NOT NULL
   DROP TABLE dbo.T_compagnie;
GO

